{********************************************
; File: Fonts.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT FONTS;
INTERFACE
USES TYPES,QUICKDRAW;
CONST

{ Error Codes }
fmDupStartUpErr = $1B01;  { duplicate FMStartUp call }
fmResetErr = $1B02;  { can't reset the Font Manager }
fmNotActiveErr = $1B03;  { Font Manager not active }
fmFamNotFndErr = $1B04;  { family not found }
fmFontNtFndErr = $1B05;  { font not found }
fmFontMemErr = $1B06;  { font not in memory }
fmSysFontErr = $1B07;  { system font cannot be purgeable }
fmBadFamNumErr = $1B08;  { illegal family number }
fmBadSizeErr = $1B09;  { illegal size }
fmBadNameErr = $1B0A;  { illegal name length }
fmMenuErr = $1B0B;  { fix font menu never called }
fmScaleSizeErr = $1B0C;  { scaled size of font exeeds limits }

{ Font Family Numbers }
chicago = $FFFD;
shaston = $FFFE;
systemFont0 = $0000;
systemFont1 = $0001;
newYork = $0002;
geneva = $0003;
monaco = $0004;
venice = $0005;
london = $0006;
athens = $0007;
sanFrancisco = $0008;
toronto = $0009;
cairo = $000B;
losAngeles = $000C;
zapfDingbats = $000D;
bookman = $000E;
helveticaNarrow = $000F;
palatino = $0010;
zapfChancery = $0012;
times = $0014;
helvetica = $0015;
courier = $0016;
symbol = $0017;
taliesin = $0018;
avanteGarde = $0021;
newCenturySchoolbook = $0022;
baseOnlyBit = $0020;  { FamSpecBits }
notBaseBit = $0020;  { FamStatBits }
memOnlyBit = $0001;  { FontSpecBits }
realOnlyBit = $0002;  { FontSpecBits }
anyFamBit = $0004;  { FontSpecBits }
anyStyleBit = $0008;  { FontSpecBits }
anySizeBit = $0010;  { FontSpecBits }
memBit = $0001;  { FontStatBits }
unrealBit = $0002;  { FontStatBits }
apFamBit = $0004;  { FontStatBits }
apVarBit = $0008;  { FontStatBits }
purgeBit = $0010;  { FontStatBits }
notDiskBit = $0020;  { FontStatBits }
notFoundBit = $8000;  { FontStatBits }
dontScaleBit = $0001;  { Scale Word }
TYPE
FontStatRecHndl = ^FontStatRecPtr;
FontStatRecPtr = ^FontStatRec;
FontStatRec = RECORD
    resultID : FontID;
    resultStats : Integer;
END;
PROCEDURE AddFamily ( famNum:Integer; famName:Str255)  ;
PROCEDURE AddFontVar ( fontHandle:FontHndl; newSpecs:Integer)  ;
FUNCTION ChooseFont ( currentID:FontID; famSpecs:Integer) : FontID ;
FUNCTION CountFamilies ( famSpecs:Integer) : Integer ;
FUNCTION CountFonts ( desiredID:FontId; fontSpecs:Integer) : Integer ;
FUNCTION FamNum2ItemID ( famNum:Integer) : Integer ;
FUNCTION FindFamily ( famSpecs:Integer; positionNum:Integer; famName:Str255) : Integer ;
PROCEDURE FindFontStats ( desiredID:FontId; fontSpecs:Integer; positionNum:Integer;VAR resultPtr:FontStatRec)  ;
PROCEDURE FixFontMenu ( menuID:Integer; startingID:Integer; famSpecs:Integer)  ;
PROCEDURE FMBootInit   ;
FUNCTION FMGetCurFID  : FontID ;
FUNCTION FMGetSysFID  : FontID ;
PROCEDURE FMReset   ;
PROCEDURE FMSetSysFont ( newFontID:FontID)  ;
PROCEDURE FMShutDown   ;
PROCEDURE FMStartUp ( userID:Integer; dPageAddr:Integer)  ;
FUNCTION FMStatus  : Boolean ;
FUNCTION FMVersion  : Integer ;
FUNCTION GetFamInfo ( famNum:Integer; famName:Str255) : Integer ;
FUNCTION GetFamNum ( famName:Str255) : Integer ;
PROCEDURE InstallFont ( desiredID:FontID; scaleWord:Integer)  ;
PROCEDURE InstallWithStats ( desiredID:FontID; scaleWord:Integer;VAR resultPtr:FontStatRec)  ;
FUNCTION ItemID2FamNum ( itemID:Integer) : Integer ;
PROCEDURE LoadFont ( desiredID:FontID; fontSpecs:Integer; positionNum:Integer;VAR resultPtr:FontStatRec)  ;
PROCEDURE LoadSysFont   ;
PROCEDURE SetPurgeStat ( theFontID:FontID; purgeStat:Integer)  ;
IMPLEMENTATION
END.
